package com.ejie.ab04b.dao.solicitud;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.model.solicitud.SolicDatosNotificacion;
import com.ejie.ab04b.model.solicitud.SolicOS2;

/**
 * SolicOS2DaoImpl generated by UDA, 11-abr-2017 8:58:36.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class SolicOS2DaoImpl implements SolicOS2Dao {

	private static String QUERY_SELECT = "SELECT t1.ID_SOLICITUD_060 IDSOLICITUD060, t1.TEROS2_060 TEROS2060, t1.ANOOS2_060 ANOOS2060, t1.NUMOS2_060 NUMOS2060, t1.FECPRE_060 FECPRE060, t1.FECIER_060 FECIER060, t1.TEROS2060 TERAPE060, t1.ANOOS2060 ANOAPE060, t1.NUMOS2060 NUMAPE060, t1.TIPDOC_060 TIPDOC060, t1.NUMDOC_060 NUMDOC060, t1.NOMEMP_060 NOMEMP060, t1.PRVEMP_060 PRVEMP060, t1.MUNEMP_060 MUNEMP060, t1.DIREMP_060 DIREMP060, t1.CPOEMP_060 CPOEMP060, t1.TLFEMP_060 TLFEMP060, t1.FAXEMP_060 FAXEMP060, t1.EMAEMP_060 EMAEMP060, t1.HTTPEMP_060 HTTPEMP060, t1.CNAEEMP_060 CNAEEMP060, t1.INDANX_060 INDANX060, t1.APDOANX_060 APDOANX060, t1.PRVCTR_060 PRVCTR060, t1.MUNCTR_060 MUNCTR060, t1.LOCCTR_060 LOCCTR060, t1.DIRCTR_060 DIRCTR060, t1.CPOCTR_060 CPOCTR060, t1.TRBTOT_060 TRBTOT060, t1.TIPMPR1_060 TIPMPR1060, t1.NOMMPR1_060 NOMMPR1060, t1.TIPMPR2_060 TIPMPR2060, t1.NOMMPR2_060 NOMMPR2060, t1.TOPSEG1_060 TOPSEG1060, t1.TOPSEG2_060 TOPSEG2060, t1.TOPHIG1_060 TOPHIG1060, t1.TOPHIG2_060 TOPHIG2060, t1.TOPERG1_060 TOPERG1060, t1.TOPERG2_060 TOPERG2060, t1.TOPVIG1_060 TOPVIG1060, t1.TOPVIG2_060 TOPVIG2060, t1.TIPRIE1_060 TIPRIE1060, t1.NOMRIE1_060 NOMRIE1060, t1.TIPRIE2_060 TIPRIE2060, t1.NOMRIE2_060 NOMRIE2060, t1.INDAUD_060 INDAUD060, t1.FECAUD_060 FECAUD060, t1.EMPAUD_060 EMPAUD060, t1.OBSERV_060 OBSERV060, t1.CODCTR_060 CODCTR060, t1.FECALT_060 FECALT060, t1.USUALT_060 USUALT060, t1.FECMOD_060 FECMOD060, t1.USUMOD_060 USUMOD060, t1.DMUNEMP_060 DMUNEMP060, t1.DESCEMP_060 DESCEMP060, t1.DESCCEN_060 DESCCEN060, t1.PAISEMP_060 PAISEMP060, t1.DOCCORRECTA_060 DOCCORRECTA060, t1.CODEMPAUD_060 CODEMPAUD060, t1.CODPREV1_060 CODPREV1060, t1.CODPREV2_060 CODPREV2060, t1.ESTADO_060 ESTADO060, t1.FORPRE_060 FORPRE060, t1.MIGRADO_060 MIGRADO060, t1.FOLDER_ID_060 FOLDERID060, t1.COD_DATOS_NOTIF_060 CODDATOSNOTIF060, t1.NUMDOCREPRESENTANTE_060 NUMDOCREPRESENTANTE060, t1.TLFREPRESENTANTE_060 TLFREPRESENTANTE060, t1.TIT_REPR_060 TITREPR060, t1.NOMREPRESENTANTE_060 NOMREPRESENTANTE060, t1.TIPDOCREPRESENTANTE_060 TIPDOCREPRESENTANTE060, t1.TIPOSOL_060 TIPOSOL060, t1.ESTADO_SOLICITUD_060 ESTADOSOLICITUD060, t1.NUMREGISTRO_060 NUMREGISTRO060,T1.CNAEEMP93_060 CNAEEMP93060,t1.DESC_ESTADO_SOL_060 DESCESTADOSOLICITUD060 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<SolicOS2> rwMap = new RowMapper<SolicOS2>() {
		public SolicOS2 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new SolicOS2(resultSet.getLong("IDSOLICITUD060"),
					resultSet.getString("TEROS2060"),
					resultSet.getString("ANOOS2060"),
					resultSet.getInt("NUMOS2060"),
					resultSet.getDate("FECPRE060"),
					resultSet.getDate("FECIER060"),
					resultSet.getString("TERAPE060"),
					resultSet.getString("ANOAPE060"),
					resultSet.getInt("NUMAPE060"),
					resultSet.getString("TIPDOC060"),
					resultSet.getString("NUMDOC060"),
					resultSet.getString("NOMEMP060"),
					new Provincia(resultSet.getString("PRVEMP060")),
					new Municipio(resultSet.getString("MUNEMP060")),
					resultSet.getString("DIREMP060"),
					resultSet.getString("CPOEMP060"),
					resultSet.getString("TLFEMP060"),
					resultSet.getString("FAXEMP060"),
					resultSet.getString("EMAEMP060"),
					resultSet.getString("HTTPEMP060"),
					resultSet.getString("CNAEEMP060"),
					resultSet.getString("INDANX060"),
					resultSet.getString("APDOANX060"),
					new Provincia(resultSet.getString("PRVCTR060")),
					new Municipio(resultSet.getString("MUNCTR060")),
					new Localidad(resultSet.getString("LOCCTR060")),
					resultSet.getString("DIRCTR060"),
					resultSet.getString("CPOCTR060"),
					resultSet.getInt("TRBTOT060"),
					resultSet.getString("TIPMPR1060"),
					resultSet.getString("NOMMPR1060"),
					resultSet.getString("TIPMPR2060"),
					resultSet.getString("NOMMPR2060"),
					resultSet.getString("TOPSEG1060"),
					resultSet.getString("TOPSEG2060"),
					resultSet.getString("TOPHIG1060"),
					resultSet.getString("TOPHIG2060"),
					resultSet.getString("TOPERG1060"),
					resultSet.getString("TOPERG2060"),
					resultSet.getString("TOPVIG1060"),
					resultSet.getString("TOPVIG2060"),
					resultSet.getString("TIPRIE1060"),
					resultSet.getString("NOMRIE1060"),
					resultSet.getString("TIPRIE2060"),
					resultSet.getString("NOMRIE2060"),
					resultSet.getString("INDAUD060"),
					resultSet.getDate("FECAUD060"),
					resultSet.getString("EMPAUD060"),
					resultSet.getString("OBSERV060"),
					resultSet.getInt("CODCTR060"),
					resultSet.getDate("FECALT060"),
					resultSet.getString("USUALT060"),
					resultSet.getDate("FECMOD060"),
					resultSet.getString("USUMOD060"),
					resultSet.getString("DMUNEMP060"),
					resultSet.getString("DESCEMP060"),
					resultSet.getString("DESCCEN060"),
					new Pais(resultSet.getString("PAISEMP060")),
					resultSet.getString("DOCCORRECTA060"),
					resultSet.getString("CODEMPAUD060"),
					resultSet.getString("CODPREV1060"),
					resultSet.getString("CODPREV2060"),
					resultSet.getString("ESTADO060"),
					resultSet.getString("FORPRE060"),
					resultSet.getString("MIGRADO060"),
					resultSet.getString("FOLDERID060"),
					new SolicDatosNotificacion(
							resultSet.getInt("CODDATOSNOTIF060")),
					resultSet.getString("NUMDOCREPRESENTANTE060"),
					resultSet.getString("TLFREPRESENTANTE060"),
					resultSet.getString("TITREPR060"),
					resultSet.getString("NOMREPRESENTANTE060"),
					resultSet.getString("TIPDOCREPRESENTANTE060"),
					resultSet.getLong("TIPOSOL060"),
					resultSet.getString("ESTADOSOLICITUD060"),
					resultSet.getString("NUMREGISTRO060"),
					resultSet.getString("CNAEEMP93060"),
					resultSet.getString("DESCESTADOSOLICITUD060"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource
	 *            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/**
	 * Finds a single row in the SolicOS2 table.
	 * 
	 *  numRegSolicitud
	 *            String
	 *  SolicOS2
	 *
	 * @param numRegSolicitud the num reg solicitud
	 * @return the solic OS 2
	 */
	@Transactional(readOnly = true)
	public SolicOS2 findSolicitud(String numRegSolicitud) {
		StringBuilder query = new StringBuilder(SolicOS2DaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.NUMREGISTRO_060 = ? ");

		List<SolicOS2> SolicOS2List = this.jdbcTemplate.query(query.toString(),
				this.rwMap, numRegSolicitud);
		return (SolicOS2) DataAccessUtils.uniqueResult(SolicOS2List);
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  solicitudes
	 *            Solicitudes
	 *  Solicitudes
	 *
	 * @param solicitudes the solicitudes
	 * @return the solic OS 2
	 */
	public SolicOS2 updateDatosApe(SolicOS2 solicitudes) {
		String query = "UPDATE AB0460S01 SET ANOOS2060 = ?, NUMOS2060= ?, TEROS2060= ? WHERE ID_SOLICITUD_060 = ? ";
		this.jdbcTemplate.update(query, solicitudes.getAnoape060(),
				solicitudes.getNumape060(), solicitudes.getTerape060(),
				solicitudes.getIdSolicitud060());
		return solicitudes;
	}

	/**
	 * Updates a single row in the Solicitudes table.
	 * 
	 *  solicitudes
	 *            Solicitudes
	 *  Solicitudes
	 *
	 * @param solicitudes the solicitudes
	 * @return the solic OS 2
	 */
	public SolicOS2 updateEstado(SolicOS2 solicitudes) {
		String query = "UPDATE AB0460S01 SET ESTADO_SOLICITUD_060 = ? WHERE ID_SOLICITUD_060 = ? ";
		this.jdbcTemplate.update(query, solicitudes.getEstadoSolicitud060(),
				solicitudes.getIdSolicitud060());
		return solicitudes;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
